<div class="col-12 d-flex mb-4 align-items-center">
    @if ($prev_week)
        <div class="mr-5">
            <button type="button" id="previous-week" data-href="{{ $prev_week }}"
                class="calendar-nav btn btn-primary">
                <i class="fas fa-chevron-left"></i>
                {{ __('admin/appointments.btn.prev_week') }}
            </button>
        </div>
    @endif
    <span class="h3 mx-auto"> {{ $date_range_title }}</span>
    @if ($next_week)
        <div class="ml-5">
            <button type="button" id="next-week" data-href="{{ $next_week }}" class="calendar-nav btn btn-primary">
                {{ __('admin/appointments.btn.next_week') }}
                <i class="fas fa-chevron-right"></i>
            </button>
        </div>
    @endif
</div>
<div class="col-12">
    <input type="hidden" id="ap-week" name="ap-week">
    <input type="hidden" id="ap-date" name="ap-date">
    <input type="hidden" id="ap-session" name="ap-session">
    <table id="service-sessions" class="table table-bordered w-100">
        <tbody>
            @if ($calendar)
                @foreach ($calendar as $day)
                    <tr>
                        <td>
                            <h5>{{ $day['day'] }}</h5>
                            <span>{{ $day['date'] }}</span>
                        </td>
                        @if (!empty(array_filter($day['free_sessions'])))
                            @foreach ($day['free_sessions'] as $key => $free_session)
                                <td colspan="{{ $selected_service_slots }}">
                                    <?php $rand = rand(0, 999); ?>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" id="appointment-{{ $rand }}" name="appointment"
                                            class="custom-control-input" data-week="{{ $week_no }}"
                                            data-date="{{ $day['date'] }}" data-session="{{ $key }}">
                                        <label class="custom-control-label"
                                            for="appointment-{{ $rand }}">{{ date('h:i A', strtotime($free_session)) }}</label>
                                    </div>
                                </td>
                            @endforeach
                        @endif
                    </tr>
                @endforeach
            @endif
        </tbody>
    </table>
</div>
<div class="col-12 col-md-8 col-lg-4 col-xl-3 mx-auto">
    <button type="submit" class="btn btn-primary btn-block btn-lg" title="{{ __('admin/common.buttons.save') }}">
        {{ __('admin/common.buttons.save') }}
    </button>
</div>
<script>
    $(document).ready(function() {

        $(document).on('click', '.calendar-nav', function(e) {

            e.preventDefault();

            let href = $(this).attr('data-href');

            $.ajax({
                type: "GET",
                url: href,
                dataType: "html",
                beforeSend: function() {
                    $('#loading-overlay').addClass('is-active');
                },
                error: function(XMLHttpRequest) {
                    alert('error');
                    $('#loading-overlay').removeClass('is-active');
                },
                success: function(data) {
                    $('#sessions-table').html(data);
                    $('#loading-overlay').removeClass('is-active');
                },
            });
        });

        $(document).on('click', 'input[name="appointment"]', function(e) {

            if ($(this).is(':checked')) {

                $('#ap-week').val($(this).attr('data-week'));
                $('#ap-date').val($(this).attr('data-date'));
                $('#ap-session').val($(this).attr('data-session'));

            }
        });
    });
</script>
